export const getMinMaxSale = (priceData, symbol_position, dflt_currency_symbol) => {
    if (!priceData || !priceData.regularPrice || !priceData.salePrice) {
        return null;
    }
    const regularPrices = priceData?.regularPrice?.match(/\d+/g).map(Number);
    const salePrices = priceData?.salePrice?.match(/\d+/g).map(Number);

    const minValue = Math.min(...regularPrices, ...salePrices);
    const maxSaleValue = salePrices[salePrices.length - 1];

    const formattedMinValue = symbol_position === 'before' ? `${dflt_currency_symbol}${minValue}` : `${minValue}${dflt_currency_symbol}`;
    const formattedMaxSaleValue = symbol_position === 'before' ? `${dflt_currency_symbol}${maxSaleValue}` : `${maxSaleValue}${dflt_currency_symbol}`;

    return `${formattedMinValue} - ${formattedMaxSaleValue}`;
};